<?php
include("includes/auth.php");
include("includes/db.php");

if (!isset($_GET['form_id'])) {
    header('Location: view_forms.php');
    exit();
}

$form_id = intval($_GET['form_id']);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $q = $_POST['question'];
    $type = $_POST['type'];
    $options = isset($_POST['options']) ? $_POST['options'] : '';
    $stmt = $conn->prepare("INSERT INTO questions (form_id, question_text, type, options) VALUES (?, ?, ?, ?)");
    $stmt->bind_param('isss', $form_id, $q, $type, $options);
    $stmt->execute();
    $stmt->close();
}

$questions = $conn->query("SELECT * FROM questions WHERE form_id='$form_id'");
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Adicionar Perguntas</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
<div class="nav">
    <a href="dashboard.php">🏠 Painel</a>
    <a href="view_forms.php">📄 Ver Formulários</a>
</div>

<div class="container">
    <h2>Adicionar Perguntas ao Formulário</h2>
    <form method="post">
        <label>Pergunta:</label>
        <input type="text" name="question" required>
        <label>Tipo:</label>
        <select name="type">
            <option value="text">Texto</option>
            <option value="textarea">Área de Texto</option>
            <option value="select">Seleção (menu)</option>
        </select>
        <label>Opções (separadas por vírgula, se tipo = seleção):</label>
        <input type="text" name="options">
        <button type="submit">Adicionar</button>
    </form>

    <h3>Perguntas Existentes:</h3>
    <ul>
    <?php while($q = $questions->fetch_assoc()): ?>
        <li><?= htmlspecialchars($q['question_text']) ?> (<?= $q['type'] ?>)</li>
    <?php endwhile; ?>
    </ul>
    <br>
    <a href="form.php?id=<?= $form_id ?>" target="_blank"><button>🔗 Ver Formulário</button></a>
</div>
</body>
</html>
