<?php
include 'includes/config.php';
include 'includes/functions.php';

if (!isLoggedIn()) {
    header('Location: index.php');
    exit;
}

try {
    $forms = getForms($pdo);
    $totalForms = count($forms);

    // Contar respostas totais
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM responses");
    $totalResponses = $stmt->fetch()['total'];
} catch(PDOException $e) {
    $error = "Erro ao carregar dados: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - FormBuilder</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <?php include 'includes/header.php'; ?>
        
        <div class="main-content">
            <div class="header">
                <h1>Dashboard</h1>
                <a href="create_form.php" class="btn btn-primary">Criar Novo Formulário</a>
            </div>
            
            <?php if (isset($error)): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <div class="stats">
                <div class="stat-card">
                    <h3>Total de Formulários</h3>
                    <p><?php echo $totalForms; ?></p>
                </div>
                <div class="stat-card">
                    <h3>Total de Respostas</h3>
                    <p><?php echo $totalResponses; ?></p>
                </div>
            </div>
            
            <div class="card">
                <h2>Formulários Recentes</h2>
                <?php if ($forms): ?>
                    <div class="forms-grid">
                        <?php foreach ($forms as $form): ?>
                            <div class="form-card">
                                <h3><?php echo htmlspecialchars($form['title']); ?></h3>
                                <p><?php echo htmlspecialchars($form['description']); ?></p>
                                <div class="form-actions">
                                    <a href="form.php?id=<?php echo $form['id']; ?>" target="_blank" class="btn btn-secondary">Ver Formulário</a>
                                    <a href="view_responses.php?form_id=<?php echo $form['id']; ?>" class="btn btn-info">Ver Respostas</a>
                                    <a href="create_form.php?edit=<?php echo $form['id']; ?>" class="btn btn-warning">Editar</a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p>Nenhum formulário criado ainda.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>