<?php
include 'includes/config.php';
include 'includes/functions.php';

$form_id = $_GET['id'] ?? null;
$form = $form_id ? getForm($pdo, $form_id) : null;
$questions = $form_id ? getQuestions($pdo, $form_id) : [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Salvar resposta
    $stmt = $pdo->prepare("INSERT INTO responses (form_id) VALUES (?)");
    $stmt->execute([$form_id]);
    $response_id = $pdo->lastInsertId();
    
    // Salvar respostas individuais
    foreach ($_POST['answers'] as $question_id => $answer) {
        if (is_array($answer)) {
            $answer_text = implode(', ', $answer);
        } else {
            $answer_text = $answer;
        }
        
        $stmt = $pdo->prepare("INSERT INTO response_answers (response_id, question_id, answer_text) VALUES (?, ?, ?)");
        $stmt->execute([$response_id, $question_id, $answer_text]);
    }
    
    $success = "Resposta enviada com sucesso!";
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $form ? htmlspecialchars($form['title']) : 'Formulário'; ?> - FormBuilder</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="public-container">
        <?php if ($form): ?>
            <?php if (isset($success)): ?>
                <div class="success-message">
                    <h2>Obrigado!</h2>
                    <p><?php echo $success; ?></p>
                    <a href="form.php?id=<?php echo $form_id; ?>">Enviar outra resposta</a>
                </div>
            <?php else: ?>
                <div class="public-form">
                    <h1><?php echo htmlspecialchars($form['title']); ?></h1>
                    <p class="form-description"><?php echo htmlspecialchars($form['description']); ?></p>
                    
                    <form method="POST">
                        <?php foreach ($questions as $question): ?>
                            <div class="form-group">
                                <label><?php echo htmlspecialchars($question['question_text']); ?></label>
                                
                                <?php if ($question['question_type'] == 'text'): ?>
                                    <input type="text" name="answers[<?php echo $question['id']; ?>]" required>
                                
                                <?php elseif ($question['question_type'] == 'textarea'): ?>
                                    <textarea name="answers[<?php echo $question['id']; ?>]" rows="4" required></textarea>
                                
                                <?php elseif ($question['question_type'] == 'radio'): ?>
                                    <?php $options = getQuestionOptions($pdo, $question['id']); ?>
                                    <?php foreach ($options as $option): ?>
                                        <div class="radio-option">
                                            <input type="radio" name="answers[<?php echo $question['id']; ?>]" value="<?php echo htmlspecialchars($option['option_text']); ?>" required>
                                            <label><?php echo htmlspecialchars($option['option_text']); ?></label>
                                        </div>
                                    <?php endforeach; ?>
                                
                                <?php elseif ($question['question_type'] == 'checkbox'): ?>
                                    <?php $options = getQuestionOptions($pdo, $question['id']); ?>
                                    <?php foreach ($options as $option): ?>
                                        <div class="checkbox-option">
                                            <input type="checkbox" name="answers[<?php echo $question['id']; ?>][]" value="<?php echo htmlspecialchars($option['option_text']); ?>">
                                            <label><?php echo htmlspecialchars($option['option_text']); ?></label>
                                        </div>
                                    <?php endforeach; ?>
                                
                                <?php elseif ($question['question_type'] == 'select'): ?>
                                    <?php $options = getQuestionOptions($pdo, $question['id']); ?>
                                    <select name="answers[<?php echo $question['id']; ?>]" required>
                                        <option value="">Selecione...</option>
                                        <?php foreach ($options as $option): ?>
                                            <option value="<?php echo htmlspecialchars($option['option_text']); ?>"><?php echo htmlspecialchars($option['option_text']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                        
                        <button type="submit" class="btn btn-primary">Enviar Resposta</button>
                    </form>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="error-message">
                <h2>Formulário não encontrado</h2>
                <p>O formulário que você está tentando acessar não existe ou foi removido.</p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>