<?php
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function redirect($url) {
    header("Location: $url");
    exit;
}

function getForms($pdo) {
    $stmt = $pdo->prepare("SELECT * FROM forms ORDER BY created_at DESC");
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function getForm($pdo, $id) {
    $stmt = $pdo->prepare("SELECT * FROM forms WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

function getQuestions($pdo, $form_id) {
    $stmt = $pdo->prepare("SELECT * FROM questions WHERE form_id = ? ORDER BY question_order");
    $stmt->execute([$form_id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function getQuestionOptions($pdo, $question_id) {
    $stmt = $pdo->prepare("SELECT * FROM question_options WHERE question_id = ?");
    $stmt->execute([$question_id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>