<?php
include 'includes/config.php';

// Verificar se precisa instalar
if (!file_exists('includes/config.php') || filesize('includes/config.php') < 50) {
    header('Location: install.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND password = ?");
        $stmt->execute([$username, $password]);
        $user = $stmt->fetch();
        
        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            header('Location: dashboard.php');
            exit;
        } else {
            $error = "Usuário ou senha inválidos!";
        }
    } catch(PDOException $e) {
        $error = "Erro no banco de dados: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - FormBuilder</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="login-container">
        <div class="login-form">
            <h1>FormBuilder</h1>
            <h2>Login</h2>
            
            <?php if (isset($error)): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Usuário:</label>
                    <input type="text" name="username" value="admin" required>
                </div>
                
                <div class="form-group">
                    <label>Senha:</label>
                    <input type="password" name="password" value="admin" required>
                </div>
                
                <button type="submit" class="btn btn-primary">Entrar</button>
            </form>
            
            <div class="login-info">
                <p><strong>Usuário padrão:</strong> admin</p>
                <p><strong>Senha padrão:</strong> admin</p>
            </div>
        </div>
    </div>
</body>
</html>