<?php
// install.php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $host = $_POST['host'] ?? 'localhost';
    $dbname = $_POST['dbname'] ?? 'form_builder';
    $username = $_POST['username'] ?? 'root';
    $password = $_POST['password'] ?? '';
    
    try {
        $pdo = new PDO("mysql:host=$host", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Criar banco de dados
        $pdo->exec("CREATE DATABASE IF NOT EXISTS $dbname");
        $pdo->exec("USE $dbname");
        
        // Criar tabelas
        $sql = "
        -- Tabela de usuários
        CREATE TABLE IF NOT EXISTS users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        );

        -- Tabela de formulários
        CREATE TABLE IF NOT EXISTS forms (
            id INT AUTO_INCREMENT PRIMARY KEY,
            title VARCHAR(255) NOT NULL,
            description TEXT,
            created_by INT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        );

        -- Tabela de perguntas
        CREATE TABLE IF NOT EXISTS questions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            form_id INT,
            question_text TEXT NOT NULL,
            question_type ENUM('text', 'textarea', 'radio', 'checkbox', 'select') NOT NULL,
            question_order INT,
            FOREIGN KEY (form_id) REFERENCES forms(id) ON DELETE CASCADE
        );

        -- Tabela de opções para perguntas
        CREATE TABLE IF NOT EXISTS question_options (
            id INT AUTO_INCREMENT PRIMARY KEY,
            question_id INT,
            option_text VARCHAR(255) NOT NULL,
            FOREIGN KEY (question_id) REFERENCES questions(id) ON DELETE CASCADE
        );

        -- Tabela de respostas
        CREATE TABLE IF NOT EXISTS responses (
            id INT AUTO_INCREMENT PRIMARY KEY,
            form_id INT,
            submitted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (form_id) REFERENCES forms(id) ON DELETE CASCADE
        );

        -- Tabela de respostas individuais
        CREATE TABLE IF NOT EXISTS response_answers (
            id INT AUTO_INCREMENT PRIMARY KEY,
            response_id INT,
            question_id INT,
            answer_text TEXT,
            FOREIGN KEY (response_id) REFERENCES responses(id) ON DELETE CASCADE,
            FOREIGN KEY (question_id) REFERENCES questions(id)
        );

        -- Inserir usuário padrão (admin/admin)
        INSERT IGNORE INTO users (username, password) VALUES ('admin', 'admin');
        ";
        
        $pdo->exec($sql);
        
        // Criar arquivo config
        $config_content = "<?php
session_start();

define('DB_HOST', '$host');
define('DB_NAME', '$dbname');
define('DB_USER', '$username');
define('DB_PASS', '$password');

try {
    \$pdo = new PDO(\"mysql:host=\" . DB_HOST . \";dbname=\" . DB_NAME . \";charset=utf8\", DB_USER, DB_PASS);
    \$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException \$e) {
    die(\"Erro na conexão: \" . \$e->getMessage());
}
?>";
        
        file_put_contents('includes/config.php', $config_content);
        
        echo "<div style='color: green;'>Instalação concluída com sucesso! <a href='index.php'>Fazer login</a></div>";
        
    } catch(PDOException $e) {
        echo "<div style='color: red;'>Erro na instalação: " . $e->getMessage() . "</div>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Instalar FormBuilder</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 500px; margin: 50px auto; padding: 20px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; }
        input { width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px; }
        button { background: #007cba; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; }
    </style>
</head>
<body>
    <h1>Instalação do FormBuilder</h1>
    <form method="POST">
        <div class="form-group">
            <label>Host do MySQL:</label>
            <input type="text" name="host" value="localhost" required>
        </div>
        <div class="form-group">
            <label>Nome do Banco:</label>
            <input type="text" name="dbname" value="form_builder" required>
        </div>
        <div class="form-group">
            <label>Usuário MySQL:</label>
            <input type="text" name="username" value="root" required>
        </div>
        <div class="form-group">
            <label>Senha MySQL:</label>
            <input type="password" name="password">
        </div>
        <button type="submit">Instalar</button>
    </form>
</body>
</html>
