<?php
include 'includes/config.php';
include 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

$form_id = $_GET['form_id'] ?? null;
$form = $form_id ? getForm($pdo, $form_id) : null;
$questions = $form_id ? getQuestions($pdo, $form_id) : [];

// Buscar respostas
$responses = [];
if ($form_id) {
    $stmt = $pdo->prepare("
        SELECT r.*, GROUP_CONCAT(CONCAT(ra.question_id, ':', ra.answer_text) SEPARATOR '||') as answers
        FROM responses r
        LEFT JOIN response_answers ra ON r.id = ra.response_id
        WHERE r.form_id = ?
        GROUP BY r.id
        ORDER BY r.submitted_at DESC
    ");
    $stmt->execute([$form_id]);
    $responses = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Respostas - FormBuilder</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <?php include 'includes/header.php'; ?>
        
        <div class="main-content">
            <div class="header">
                <h1>Respostas do Formulário</h1>
                <a href="dashboard.php" class="btn btn-secondary">Voltar</a>
            </div>
            
            <?php if ($form): ?>
                <div class="card">
                    <h2><?php echo htmlspecialchars($form['title']); ?></h2>
                    <p><?php echo htmlspecialchars($form['description']); ?></p>
                </div>
                
                <div class="card">
                    <h2>Respostas Recebidas (<?php echo count($responses); ?>)</h2>
                    
                    <?php if ($responses): ?>
                        <?php foreach ($responses as $response): ?>
                            <div class="response-item">
                                <h3>Resposta de <?php echo date('d/m/Y H:i', strtotime($response['submitted_at'])); ?></h3>
                                
                                <?php
                                $answers = explode('||', $response['answers']);
                                $answer_map = [];
                                foreach ($answers as $answer) {
                                    list($qid, $atext) = explode(':', $answer, 2);
                                    $answer_map[$qid] = $atext;
                                }
                                ?>
                                
                                <?php foreach ($questions as $question): ?>
                                    <div class="answer-item">
                                        <strong><?php echo htmlspecialchars($question['question_text']); ?></strong>
                                        <p><?php echo isset($answer_map[$question['id']]) ? htmlspecialchars($answer_map[$question['id']]) : 'Não respondida'; ?></p>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>Nenhuma resposta recebida para este formulário.</p>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="card">
                    <p>Formulário não encontrado.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>