<?php
include 'includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newUsername = $_POST['new_username'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    // Validar
    if (empty($newUsername)) {
        $error = "O usuário não pode estar vazio.";
    } elseif ($newPassword && $newPassword !== $confirmPassword) {
        $error = "As senhas não coincidem.";
    } elseif ($newPassword && strlen($newPassword) < 4) {
        $error = "A senha deve ter pelo menos 4 caracteres.";
    } else {
        // Atualizar usuário
        if ($newUsername !== $_SESSION['admin_user']) {
            if ($auth->changeUsername($newUsername)) {
                $success .= "Usuário alterado com sucesso. ";
            } else {
                $error .= "Erro ao alterar usuário. ";
            }
        }
        
        // Atualizar senha
        if ($newPassword) {
            if ($auth->changePassword($newPassword)) {
                $success .= "Senha alterada com sucesso.";
            } else {
                $error .= "Erro ao alterar senha.";
            }
        }
        
        if (!$error) {
            $success = $success ?: "Nenhuma alteração foi feita.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações - Painel Administrativo</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="dashboard-container">
        <header class="header">
            <h1>Configurações</h1>
            <div class="user-info">
                <span>Bem-vindo, <?php echo $_SESSION['admin_user']; ?></span>
                <a href="logout.php" class="logout-btn">Sair</a>
            </div>
        </header>
        
        <div class="main-container">
            <nav class="sidebar">
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="mensagens.php">Mensagens Recebidas</a></li>
                    <li class="active"><a href="configuracoes.php">Configurações</a></li>
                    <li><a href="formulario.php">Formulário Público</a></li>
                </ul>
            </nav>
            
            <main class="content">
                <div class="card">
                    <h2>Configurações</h2>
                    <form method="POST">
                        <?php if ($success): ?>
                            <div class="alert alert-success"><?php echo $success; ?></div>
                        <?php endif; ?>
                        
                        <?php if ($error): ?>
                            <div class="alert alert-error"><?php echo $error; ?></div>
                        <?php endif; ?>
                        
                        <div class="form-group">
                            <label for="new_username">Novo Usuário</label>
                            <input type="text" id="new_username" name="new_username" class="form-control" 
                                   value="<?php echo $_SESSION['admin_user']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="new_password">Nova Senha</label>
                            <input type="password" id="new_password" name="new_password" class="form-control" 
                                   placeholder="Deixe em branco para manter a atual">
                        </div>
                        <div class="form-group">
                            <label for="confirm_password">Confirmar Nova Senha</label>
                            <input type="password" id="confirm_password" name="confirm_password" class="form-control">
                        </div>
                        <button type="submit" class="btn">Salvar Alterações</button>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>