<?php
include 'includes/auth.php';
include 'includes/functions.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

$functions = new Functions();
$stats = $functions->getStats();
$recentMessages = $functions->getMessages(3);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Painel Administrativo</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="dashboard-container">
        <header class="header">
            <h1>Painel Administrativo</h1>
            <div class="user-info">
                <span>Bem-vindo, <?php echo $_SESSION['admin_user']; ?></span>
                <a href="logout.php" class="logout-btn">Sair</a>
            </div>
        </header>
        
        <div class="main-container">
            <nav class="sidebar">
                <ul>
                    <li class="active"><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="mensagens.php">Mensagens Recebidas</a></li>
                    <li><a href="configuracoes.php">Configurações</a></li>
                    <li><a href="formulario.php">Formulário Público</a></li>
                </ul>
            </nav>
            
            <main class="content">
                <div class="card">
                    <h2>Dashboard</h2>
                    <div class="stats-container">
                        <div class="stat-card">
                            <h3><?php echo $stats['total']; ?></h3>
                            <p>Total de Mensagens</p>
                        </div>
                        <div class="stat-card">
                            <h3><?php echo $stats['unread']; ?></h3>
                            <p>Mensagens Não Lidas</p>
                        </div>
                        <div class="stat-card">
                            <h3><?php echo $stats['today']; ?></h3>
                            <p>Mensagens Hoje</p>
                        </div>
                    </div>
                    
                    <h3>Atividade Recente</h3>
                    <div id="recentActivity">
                        <?php if (empty($recentMessages)): ?>
                            <p>Nenhuma atividade recente.</p>
                        <?php else: ?>
                            <?php foreach ($recentMessages as $message): ?>
                                <div style="padding: 0.5rem 0; border-bottom: 1px solid #eee;">
                                    <strong><?php echo htmlspecialchars($message['name']); ?></strong> 
                                    enviou uma mensagem sobre "<?php echo htmlspecialchars($message['subject']); ?>"
                                    <?php echo $message['is_read'] ? 
                                        '<span class="badge badge-success">Lida</span>' : 
                                        '<span class="badge badge-warning">Não lida</span>'; ?>
                                    <div style="font-size: 0.8rem; color: #777;">
                                        <?php echo date('d/m/Y H:i', strtotime($message['created_at'])); ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>