<?php
include 'includes/functions.php';

$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $message = $_POST['message'] ?? '';
    
    if (!empty($name) && !empty($email) && !empty($subject) && !empty($message)) {
        $functions = new Functions();
        if ($functions->addMessage($name, $email, $subject, $message)) {
            $success = true;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Entre em Contato</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="public-form-container">
        <h2>Entre em Contato</h2>
        
        <?php if ($success): ?>
            <div class="alert alert-success">
                Mensagem enviada com sucesso! Entraremos em contato em breve.
            </div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="clientName">Nome</label>
                <input type="text" id="clientName" name="name" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="clientEmail">E-mail</label>
                <input type="email" id="clientEmail" name="email" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="clientSubject">Assunto</label>
                <input type="text" id="clientSubject" name="subject" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="clientMessage">Mensagem</label>
                <textarea id="clientMessage" name="message" class="form-control" required></textarea>
            </div>
            <button type="submit" class="btn">Enviar Mensagem</button>
        </form>
    </div>
</body>
</html>