<?php
include 'includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulário Público - Painel Administrativo</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="dashboard-container">
        <header class="header">
            <h1>Formulário Público</h1>
            <div class="user-info">
                <span>Bem-vindo, <?php echo $_SESSION['admin_user']; ?></span>
                <a href="logout.php" class="logout-btn">Sair</a>
            </div>
        </header>
        
        <div class="main-container">
            <nav class="sidebar">
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="mensagens.php">Mensagens Recebidas</a></li>
                    <li><a href="configuracoes.php">Configurações</a></li>
                    <li class="active"><a href="formulario.php">Formulário Público</a></li>
                </ul>
            </nav>
            
            <main class="content">
                <div class="card">
                    <h2>Formulário Público</h2>
                    <p>Use o seguinte formulário para permitir que clientes enviem mensagens diretamente para o painel administrativo.</p>
                    <p><strong>URL do Formulário:</strong> 
                        <code><?php echo 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/formulario-publico.php'; ?></code>
                    </p>
                    
                    <div class="public-form-container">
                        <h2>Entre em Contato</h2>
                        <form action="formulario-publico.php" method="POST">
                            <div class="form-group">
                                <label for="clientName">Nome</label>
                                <input type="text" id="clientName" name="name" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="clientEmail">E-mail</label>
                                <input type="email" id="clientEmail" name="email" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="clientSubject">Assunto</label>
                                <input type="text" id="clientSubject" name="subject" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="clientMessage">Mensagem</label>
                                <textarea id="clientMessage" name="message" class="form-control" required></textarea>
                            </div>
                            <button type="submit" class="btn">Enviar Mensagem</button>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>