<?php
include 'database.php';

class Auth {
    private $db;
    
    public function __construct() {
        $this->db = new Database();
    }
    
    public function login($username, $password) {
        $conn = $this->db->getConnection();
        $stmt = $conn->prepare("SELECT * FROM admin_users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_user'] = $user['username'];
            $_SESSION['admin_id'] = $user['id'];
            return true;
        }
        return false;
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
    }
    
    public function logout() {
        session_destroy();
        header('Location: login.php');
        exit;
    }
    
    public function changePassword($newPassword) {
        if (!$this->isLoggedIn()) return false;
        
        $conn = $this->db->getConnection();
        $stmt = $conn->prepare("UPDATE admin_users SET password = ? WHERE id = ?");
        $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
        return $stmt->execute([$hashedPassword, $_SESSION['admin_id']]);
    }
    
    public function changeUsername($newUsername) {
        if (!$this->isLoggedIn()) return false;
        
        $conn = $this->db->getConnection();
        $stmt = $conn->prepare("UPDATE admin_users SET username = ? WHERE id = ?");
        $result = $stmt->execute([$newUsername, $_SESSION['admin_id']]);
        
        if ($result) {
            $_SESSION['admin_user'] = $newUsername;
        }
        return $result;
    }
}
?>