<?php
include 'database.php';

class Functions {
    private $db;
    
    public function __construct() {
        $this->db = new Database();
    }
    
    // Mensagens
    public function getMessages($limit = null) {
        $conn = $this->db->getConnection();
        $sql = "SELECT * FROM messages ORDER BY created_at DESC";
        if ($limit) {
            $sql .= " LIMIT " . intval($limit);
        }
        $stmt = $conn->query($sql);
        return $stmt->fetchAll();
    }
    
    public function getMessage($id) {
        $conn = $this->db->getConnection();
        $stmt = $conn->prepare("SELECT * FROM messages WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }
    
    public function addMessage($name, $email, $subject, $message) {
        $conn = $this->db->getConnection();
        $stmt = $conn->prepare("INSERT INTO messages (name, email, subject, message) VALUES (?, ?, ?, ?)");
        return $stmt->execute([$name, $email, $subject, $message]);
    }
    
    public function markAsRead($id) {
        $conn = $this->db->getConnection();
        $stmt = $conn->prepare("UPDATE messages SET is_read = 1 WHERE id = ?");
        return $stmt->execute([$id]);
    }
    
    public function deleteMessage($id) {
        $conn = $this->db->getConnection();
        $stmt = $conn->prepare("DELETE FROM messages WHERE id = ?");
        return $stmt->execute([$id]);
    }
    
    // Estatísticas
    public function getStats() {
        $conn = $this->db->getConnection();
        
        $total = $conn->query("SELECT COUNT(*) as total FROM messages")->fetch()['total'];
        $unread = $conn->query("SELECT COUNT(*) as unread FROM messages WHERE is_read = 0")->fetch()['unread'];
        $today = $conn->query("SELECT COUNT(*) as today FROM messages WHERE DATE(created_at) = CURDATE()")->fetch()['today'];
        
        return [
            'total' => $total,
            'unread' => $unread,
            'today' => $today
        ];
    }
}
?>