<?php
include 'includes/auth.php';
include 'includes/functions.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

$functions = new Functions();

// Marcar como lida
if (isset($_GET['mark_read']) && is_numeric($_GET['mark_read'])) {
    $functions->markAsRead($_GET['mark_read']);
    header('Location: mensagens.php');
    exit;
}

// Excluir mensagem
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $functions->deleteMessage($_GET['delete']);
    header('Location: mensagens.php');
    exit;
}

$messages = $functions->getMessages();
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mensagens - Painel Administrativo</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="dashboard-container">
        <header class="header">
            <h1>Mensagens Recebidas</h1>
            <div class="user-info">
                <span>Bem-vindo, <?php echo $_SESSION['admin_user']; ?></span>
                <a href="logout.php" class="logout-btn">Sair</a>
            </div>
        </header>
        
        <div class="main-container">
            <nav class="sidebar">
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li class="active"><a href="mensagens.php">Mensagens Recebidas</a></li>
                    <li><a href="configuracoes.php">Configurações</a></li>
                    <li><a href="formulario.php">Formulário Público</a></li>
                </ul>
            </nav>
            
            <main class="content">
                <div class="card">
                    <h2>Mensagens Recebidas</h2>
                    <table>
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>E-mail</th>
                                <th>Assunto</th>
                                <th>Data</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($messages)): ?>
                                <tr>
                                    <td colspan="6" style="text-align: center;">Nenhuma mensagem recebida.</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($messages as $message): ?>
                                    <tr class="<?php echo $message['is_read'] ? '' : 'unread'; ?>">
                                        <td><?php echo htmlspecialchars($message['name']); ?></td>
                                        <td><?php echo htmlspecialchars($message['email']); ?></td>
                                        <td><?php echo htmlspecialchars($message['subject']); ?></td>
                                        <td><?php echo date('d/m/Y H:i', strtotime($message['created_at'])); ?></td>
                                        <td>
                                            <?php echo $message['is_read'] ? 
                                                '<span class="badge badge-success">Lida</span>' : 
                                                '<span class="badge badge-warning">Não lida</span>'; ?>
                                        </td>
                                        <td class="message-actions">
                                            <a href="mensagens.php?view=<?php echo $message['id']; ?>" 
                                               class="btn-small btn-view">Ver</a>
                                            <?php if (!$message['is_read']): ?>
                                                <a href="mensagens.php?mark_read=<?php echo $message['id']; ?>" 
                                                   class="btn-small btn-view">Marcar como lida</a>
                                            <?php endif; ?>
                                            <a href="mensagens.php?delete=<?php echo $message['id']; ?>" 
                                               class="btn-small btn-delete" 
                                               onclick="return confirm('Tem certeza que deseja excluir esta mensagem?')">Excluir</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Modal para visualizar mensagem -->
                <?php if (isset($_GET['view']) && is_numeric($_GET['view'])): ?>
                    <?php 
                    $messageId = $_GET['view'];
                    $message = $functions->getMessage($messageId);
                    if ($message && !$message['is_read']) {
                        $functions->markAsRead($messageId);
                    }
                    ?>
                    <div class="modal" style="display: flex;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h3>Mensagem de <?php echo htmlspecialchars($message['name']); ?></h3>
                                <a href="mensagens.php" class="close-btn">&times;</a>
                            </div>
                            <div>
                                <p><strong>Nome:</strong> <?php echo htmlspecialchars($message['name']); ?></p>
                                <p><strong>E-mail:</strong> <?php echo htmlspecialchars($message['email']); ?></p>
                                <p><strong>Assunto:</strong> <?php echo htmlspecialchars($message['subject']); ?></p>
                                <p><strong>Data:</strong> <?php echo date('d/m/Y H:i', strtotime($message['created_at'])); ?></p>
                                <p><strong>Mensagem:</strong></p>
                                <div style="background-color: #f9f9f9; padding: 1rem; border-radius: 4px; margin-top: 0.5rem;">
                                    <?php echo nl2br(htmlspecialchars($message['message'])); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </main>
        </div>
    </div>
</body>
</html>